//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick  2.4

import wesual.Controls 1.0

Dialog {
    id : progressDialog

    property string processingLabel             : ""
    property string processingInstructionText   : ""
    property string finishedLabel               : ""
    property string finishedInstructionText     : ""
    property string errorLabel                  : ""
    property string errorInstructionText        : ""

    property ProgressBar progressBar : progressDialog.contentItem ?
                                           progressDialog.contentItem.progressBar
                                         : undefined

    contentWidth : 500
    contentHeight : 120

    onOpenChanged : {
        if (!progressDialog.open)
            progressDialog.state = "processing";
    }

    state : "processing"
    buttons : customButtons
    property list<DialogButton> customButtons : [
        DialogButton {
            text : qsTrId("28c3843d05fb11e9")
            visible : progressDialog.state !== "processing"
            onClicked : {
                if (progressDialog.state === "finished") {
                    progressDialog.accept();
                    dialog.accept();
                } else {
                    progressDialog.reject()
                }
            }
        },
        DialogButton {
            text : qsTrId("37ae1dd525a0ce7a")
            visible : progressDialog.state === "processing"
            onClicked : {
                progressDialog.reject();
            }
        }
    ]

    delegate : Rectangle {
        id : progressDelegate

        property alias progressBar : progressBar

        anchors.fill : parent
        color : UI.color(UI.DialogHeader)

        state : progressDialog.state

        ProgressBar {
            id : progressBar
            height : 12
            anchors {
                top : parent.top
                left : parent.left
                right : parent.right
                leftMargin : 15
                rightMargin : 15
            }
        }

        states: [
            State {
                name: "processing"
                PropertyChanges {
                    target : progressBar
                    visible : true
                }
            },
            State {
                name: "finished"
                PropertyChanges {
                    target : progressBar
                    visible : false
                    value : 0
                }
            },
            State {
                name: "error"
                PropertyChanges {
                    target : progressBar
                    visible : false
                    value : 0
                }
            }
        ]
    }

    states: [
        State {
            name : "processing"
            PropertyChanges {
                target : progressDialog
                label : progressDialog.processingLabel
                instructionText : progressDialog.processingInstructionText
            }
        },
        State {
            name : "finished"
            PropertyChanges {
                target : progressDialog
                label : progressDialog.finishedLabel
                instructionText : progressDialog.finishedInstructionText
            }
        },
        State {
            name : "error"
            PropertyChanges {
                target : progressDialog
                label : progressDialog.errorLabel
                instructionText : progressDialog.errorInstructionText
            }
        }
    ]
}
